/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.local;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.util.Utilities;

public class LocalVirtualFile
extends AbstractVirtualFile {
    protected SeekableRandomFile file;
    protected boolean truncateAtNextWrite;

    public LocalVirtualFile(SeekableRandomFile file) {
        super(file);
        this.file = file;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        try {
            Utilities.write(this.file, inputPointer, inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        try {
            if (this.isTruncateAtNextWrite()) {
                long position = this.getPosition();
                if (position < this.file.length()) {
                    this.file.setLength(this.getPosition());
                }
                this.setTruncateAtNextWrite(false);
            }
            this.file.write(inputBuffer, inputOffset, inputLength);
        }
        catch (IOException e) {
            log.error((Object)"ioWrite", (Throwable)e);
            return -1;
        }
        return inputLength;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        switch (command) {
            case 20481: {
                if (inputLength != 0 || outputLength != 0) {
                    result = -1;
                    break;
                }
                result = 0;
                break;
            }
            case 2129939: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Checking if LoadExec is allowed on '%s'", this));
                }
                result = 0;
                break;
            }
            case 2129923: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Checking if LoadModule is allowed on '%s'", this));
                }
                result = 0;
                break;
            }
            case 2130049: 
            case 0x208082: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Checking if PRX type is allowed on '%s'", this));
                }
                result = 0;
                break;
            }
            default: {
                result = super.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }

    public boolean isTruncateAtNextWrite() {
        return this.truncateAtNextWrite;
    }

    public void setTruncateAtNextWrite(boolean truncateAtNextWrite) {
        this.truncateAtNextWrite = truncateAtNextWrite;
    }

    @Override
    public IVirtualFile duplicate() {
        try {
            return new LocalVirtualFile(new SeekableRandomFile(this.file.getFileName(), this.file.getMode()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return super.duplicate();
        }
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.noDelayTimings;
    }

    @Override
    public String toString() {
        return String.format("LocalVirtualFile %s", this.file);
    }
}

